import { world, system, ItemStack, EntityComponentTypes } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:copper_campfire_lit', {
        onTick({ block }) {
            const random = Math.random()
            if (block.below().typeId !== 'minecraft:hay_block') {
                block.dimension.spawnParticle('minecraft:campfire_smoke_particle', block.bottomCenter())
            }
            else if (block.below().typeId === 'minecraft:hay_block') {
                block.dimension.spawnParticle('minecraft:campfire_tall_smoke_particle', block.bottomCenter())
            }
            if (random < 0.1) {
                block.dimension.spawnParticle('v360:copper_pop_particle', block.bottomCenter())
            }
            if (random < 0.2) {
                block.dimension.playSound('block.campfire.crackle', block.location)
            }
        },
        onPlayerInteract({ block, player }) {
            const unlit = block.permutation.withState('v360:extinguished', true)
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            if (selectedItem.hasTag('minecraft:is_shovel')) {
                block.setPermutation(unlit)
                block.dimension.playSound('random.fizz', block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:copper_campfire_unlit', {
        onPlayerInteract({ block, player }) {
            const item = player.getComponent('equippable')
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            const lit = block.permutation.withState('v360:extinguished', false)
            if (selectedItem?.typeId === 'minecraft:flint_and_steel') {
                block.setPermutation(lit)
                block.dimension.playSound('fire.ignite', block.location)
                const inventory = player.getComponent('inventory').container
                const damage = selectedItem.getComponent("durability").damage
                const durability = selectedItem.getComponent("durability").maxDurability
                if (damage >= durability) {
                    inventory.setItem(player.selectedSlot, null)
                    player.playSound("random.break");
                    return;
                }
                else {
                    selectedItem.getComponent("durability").damage += 1
                    item.setEquipment('Mainhand', selectedItem)
                }
            }
            else if (selectedItem?.typeId === 'minecraft:fire_charge') {
                block.setPermutation(lit)
                block.dimension.playSound('mob.ghast.fireball', block.location)
                if (player.getGameMode() !== 'creative') {
                    player.runCommand(`clear @s minecraft:fire_charge 0 1`)
                }
            }
            else if (selectedItem?.getComponent("minecraft:enchantable").hasEnchantment('fire_aspect')) {
                block.setPermutation(lit)
                block.dimension.playSound('fire.ignite', block.location)
            }
        }
    })
})

system.runInterval(() => {
    world.getDimension('overworld' || 'nether' || 'the_end').getEntities().filter(
        (data) => {
            const { x, y, z } = data.location
            if (data.dimension.getBlock({ x: x, y: y - 0.1, z: z })?.hasTag('v360:copper_campfire_lit') && (!data.hasComponent('fire_immune')))
                data.applyDamage(1)
        }
    )
}, 2)